/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.designer;

import filenet.sim.apps.designer.resources.VWSIMResource;
import filenet.sim.toolkit.designer.VWSIMDesignerPreferences;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

class VWSIMPreferencesDialog
extends VWModalDialog
implements IVWDialogButtonsActionListener {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    private JCheckBox m_validateCheckBox = null;
    private JCheckBox m_addCheckInCheckBox = null;
    private JCheckBox m_createDefaultEntriesCheckBox = null;
    private VWSIMDesignerPreferences m_designerPrefs = null;
    private int m_nResult = 1;

    public VWSIMPreferencesDialog(Frame parentFrame) {
        super(parentFrame);
    }

    public void reinitialize(VWSIMDesignerPreferences designerPrefs) {
        try {
            this.m_designerPrefs = designerPrefs;
            this.setTitle(VWSIMResource.s_preferencesDialogTitle);
            Dimension dim = VWStringUtils.stringToDimension("505, 135");
            if (dim != null) {
                this.setSize(dim);
            }
            this.getContentPane().setLayout(new BorderLayout(5, 5));
            this.getContentPane().add((Component)this.getPreferenceControlPanel(), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getResult() {
        return this.m_nResult;
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        switch (event.getID()) {
            case 1: {
                this.performOKAction();
                break;
            }
            case 2: {
                this.performCancelAction();
                break;
            }
            case 32: {
                this.performHelpAction();
            }
        }
    }

    private JPanel getPreferenceControlPanel() {
        try {
            JPanel preferencesPanel = new JPanel(new GridBagLayout());
            preferencesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(5, 5, 5, 5);
            boolean bSelected = this.m_designerPrefs.getShouldValidateWorkflowDefsWithScenario();
            this.m_validateCheckBox = new JCheckBox(VWSIMResource.s_validateWorkflowsWithScenario, bSelected);
            preferencesPanel.add((Component)this.m_validateCheckBox, gbCons);
            ++gbCons.gridy;
            bSelected = this.m_designerPrefs.getShouldCreateDefaultEntries();
            this.m_createDefaultEntriesCheckBox = new JCheckBox(VWSIMResource.s_createDefaultEntries, bSelected);
            preferencesPanel.add((Component)this.m_createDefaultEntriesCheckBox, gbCons);
            return preferencesPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return new JPanel();
        }
    }

    private JPanel getButtonPanel() {
        try {
            VWDialogButtons m_buttons = new VWDialogButtons(35);
            m_buttons.addDialogButtonsActionListener(this);
            return m_buttons;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return new JPanel();
        }
    }

    private void performOKAction() {
        this.m_nResult = 1;
        this.setVisible(false);
        if (this.m_validateCheckBox != null) {
            this.m_designerPrefs.setShouldValidateWorkflowDefsWithScenario(this.m_validateCheckBox.isSelected());
        }
        if (this.m_addCheckInCheckBox != null) {
            this.m_designerPrefs.setShouldAddCheckIn(this.m_addCheckInCheckBox.isSelected());
        }
        if (this.m_createDefaultEntriesCheckBox != null) {
            this.m_designerPrefs.setShouldreateDefaultEntries(this.m_createDefaultEntriesCheckBox.isSelected());
        }
    }

    private void performCancelAction() {
        this.m_nResult = 2;
        this.setVisible(false);
    }

    private void performHelpAction() {
        VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Designer + "vwsimpreferencesdialog.htm");
    }
}

